/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.world.gen.feature.FeatureApexPredators;
import untamedwilds.world.gen.feature.FeatureCritterBurrow;
import untamedwilds.world.gen.feature.FeatureCritters;
import untamedwilds.world.gen.feature.FeatureDenseWater;
import untamedwilds.world.gen.feature.FeatureFloatingPlants;
import untamedwilds.world.gen.feature.FeatureHerbivores;
import untamedwilds.world.gen.feature.FeatureOceanSessileSpawns;
import untamedwilds.world.gen.feature.FeatureOceanSwimming;
import untamedwilds.world.gen.feature.FeatureReedClusters;
import untamedwilds.world.gen.feature.FeatureSeaAnemone;
import untamedwilds.world.gen.feature.FeatureUndergroundFaunaLarge;
import untamedwilds.world.gen.feature.FeatureUnderwaterAlgae;
import untamedwilds.world.gen.feature.FeatureVegetation;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class UntamedWildsGenerator {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"untamedwilds");
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATION = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"untamedwilds");
    public static final Map<String, Float> biodiversity_levels = new HashMap<String, Float>();
    private static final RegistryObject<Feature<CountConfiguration>> SEA_ANEMONE = UntamedWildsGenerator.regFeature("sea_anemone", () -> new FeatureSeaAnemone((Codec<CountConfiguration>)CountConfiguration.f_67568_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> REEDS = UntamedWildsGenerator.regFeature("reeds", () -> new FeatureReedClusters((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> ALGAE = UntamedWildsGenerator.regFeature("algae", () -> new FeatureUnderwaterAlgae((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<ProbabilityFeatureConfiguration>> VEGETATION = UntamedWildsGenerator.regFeature("vegetation", () -> new FeatureVegetation((Codec<ProbabilityFeatureConfiguration>)ProbabilityFeatureConfiguration.f_67858_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> FLOATING_VEGETATION = UntamedWildsGenerator.regFeature("floating_vegetation", () -> new FeatureFloatingPlants((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistryObject<TreeDecoratorType<?>> TREE_ORCHID = TREE_DECORATION.register("orchid", () -> new TreeDecoratorType(TreeDecorator.f_70021_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> UNDERGROUND = UntamedWildsGenerator.regFeature("underground", () -> new FeatureUndergroundFaunaLarge((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> APEX = UntamedWildsGenerator.regFeature("apex_predator", () -> new FeatureApexPredators((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> HERBIVORES = UntamedWildsGenerator.regFeature("herbivores", () -> new FeatureHerbivores((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> CRITTERS = UntamedWildsGenerator.regFeature("critter", () -> new FeatureCritters((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> SESSILE = UntamedWildsGenerator.regFeature("sessile", () -> new FeatureOceanSessileSpawns((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> OCEAN = UntamedWildsGenerator.regFeature("ocean_rare", () -> new FeatureOceanSwimming((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> DENSE_WATER = UntamedWildsGenerator.regFeature("dense_water", () -> new FeatureDenseWater((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final RegistryObject<Feature<NoneFeatureConfiguration>> CRITTER_BURROW = UntamedWildsGenerator.regFeature("burrow", () -> new FeatureCritterBurrow((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    private static <B extends Feature<?>> RegistryObject<B> regFeature(String name, Supplier<? extends B> supplier) {
        return FEATURES.register(name, supplier);
    }

    @SubscribeEvent
    public static void onBiomesLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.BiomeCategory.OCEAN) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Feature)SESSILE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqSessile.get());
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Feature)OCEAN.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqOcean.get());
            if (!event.getName().toString().equals("minecraft:frozen_ocean") && !event.getName().toString().equals("minecraft:deep_frozen_ocean") && ((Boolean)ConfigFeatureControl.addAnemones.get()).booleanValue()) {
                UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.VEGETAL_DECORATION, new ConfiguredFeature((Feature)SEA_ANEMONE.get(), (FeatureConfiguration)new CountConfiguration(4)), 6);
            }
        }
        if (event.getCategory() == Biome.BiomeCategory.JUNGLE) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.VEGETAL_DECORATION, new ConfiguredFeature((Feature)FLOATING_VEGETATION.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), 1, (Boolean)ConfigFeatureControl.addAlgae.get());
        }
        if (!(event.getCategory() != Biome.BiomeCategory.RIVER && event.getCategory() != Biome.BiomeCategory.JUNGLE && event.getCategory() != Biome.BiomeCategory.SWAMP || ((List)ConfigFeatureControl.reedBlacklist.get()).contains(event.getName().toString()))) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.VEGETAL_DECORATION, new ConfiguredFeature((Feature)REEDS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqReeds.get(), (Boolean)ConfigFeatureControl.addReeds.get());
        }
        if (!((List)ConfigFeatureControl.algaeBlacklist.get()).contains(event.getName().toString())) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.VEGETAL_DECORATION, new ConfiguredFeature((Feature)ALGAE.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqAlgae.get(), (Boolean)ConfigFeatureControl.addAlgae.get());
        }
        if (!((List)ConfigFeatureControl.floraBlacklist.get()).contains(event.getName().toString())) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.VEGETAL_DECORATION, new ConfiguredFeature((Feature)VEGETATION.get(), (FeatureConfiguration)new ProbabilityFeatureConfiguration(4.0f)), (Integer)ConfigFeatureControl.freqFlora.get(), (Boolean)ConfigFeatureControl.addFlora.get());
        }
        UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Feature)DENSE_WATER.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqWater.get());
        UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Boolean)ConfigFeatureControl.addBurrows.get() != false ? (Feature)CRITTER_BURROW.get() : (Feature)CRITTERS.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqCritter.get());
        UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Feature)APEX.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqApex.get());
        UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStep.Decoration.TOP_LAYER_MODIFICATION, new ConfiguredFeature((Feature)HERBIVORES.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_), (Integer)ConfigFeatureControl.freqHerbivores.get());
        if (event.getCategory() == Biome.BiomeCategory.UNDERGROUND && (Double)ConfigFeatureControl.probUnderground.get() != 0.0 && ((Boolean)ConfigMobControl.masterSpawner.get()).booleanValue()) {
            float f = ((Double)ConfigFeatureControl.probUnderground.get()).floatValue() / 3.0f;
        }
    }

    private static void registerFeatureWithFreq(BiomeLoadingEvent event, GenerationStep.Decoration decoration, ConfiguredFeature<?, ?> feature, int freq) {
        UntamedWildsGenerator.registerFeatureWithFreq(event, decoration, feature, freq, (Boolean)ConfigMobControl.masterSpawner.get());
    }

    private static void registerFeatureWithFreq(BiomeLoadingEvent event, GenerationStep.Decoration decoration, ConfiguredFeature<?, ?> feature, int freq, boolean enable) {
        if (freq > 0 && enable) {
            UntamedWildsGenerator.registerFeature(event, decoration, (Holder<PlacedFeature>)PlacementUtils.m_206506_((Holder)Holder.m_205709_(feature), (PlacementModifier[])new PlacementModifier[]{RarityFilter.m_191900_((int)freq)}), feature.f_65377_().getRegistryName());
        }
    }

    private static void registerFeature(BiomeLoadingEvent event, GenerationStep.Decoration decoration, Holder<PlacedFeature> feature, ResourceLocation name) {
        event.getGeneration().m_204201_(decoration, feature);
    }

    public static void readBioDiversityLevels() {
    }

    public static float getBioDiversityLevel(ResourceLocation biome) {
        String key = biome.toString();
        if (biodiversity_levels.containsKey(key)) {
            return biodiversity_levels.get(key).floatValue();
        }
        return 0.6f;
    }
}

